﻿using System.ComponentModel;
using System;
using System.Xml.Serialization;

namespace BMSConfigurationWarlock
{
    [XmlRoot("Database")]
    public class DatabaseConfiguration : INotifyPropertyChanged
    {
        private string databaseKey;
        private string databaseName;
        private string databaseScriptVariable;
        private string scriptVariableValue;

        [XmlElement("Key")]
        public string DatabaseKey 
        {
            get { return databaseKey; }
            set
            {
                if (databaseKey != value)
                {
                    databaseKey = value;
                    NotifyPropertyChanged(NameOf<DatabaseConfiguration>.Property(e => e.DatabaseKey));
                }
            }
        }

        [XmlElement("Name")]
        public string DatabaseName 
        { 
            get { return databaseName; }
            set 
            {
                if (databaseName != value)
                {
                    databaseName = value;
                    NotifyPropertyChanged(NameOf<DatabaseConfiguration>.Property(e => e.DatabaseName));
                }
            }
        }

        [XmlElement("Variable")]
        public string DatabaseScriptVariable
        {
            get { return databaseScriptVariable; }
            set
            {
                if (databaseScriptVariable != value)
                {
                    databaseScriptVariable = value;
                    NotifyPropertyChanged(NameOf<DatabaseConfiguration>.Property(e => e.DatabaseScriptVariable));
                }
            }
        }

        [XmlElement("Value")]
        public string ScriptVariableValue
        {
            get { return scriptVariableValue; }
            set
            {
                if (scriptVariableValue != value)
                {
                    scriptVariableValue = value;
                    NotifyPropertyChanged(NameOf<DatabaseConfiguration>.Property(e => e.ScriptVariableValue));
                }
            }
        }
        

        public event PropertyChangedEventHandler PropertyChanged;

        private void NotifyPropertyChanged(String info)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(info));
            }
        }
    }
}
